/*
 * 쌠: Copyright (c) 2007|2008 ZIGEN
 * CZXFEclipse Public License - v 1.0 
 * Fhttp://www.eclipse.org/legal/epl-v10.html
 */
package zigen.sql.parser;

import junit.framework.TestCase;
import kry.sql.format.SqlFormatRule;
import zigen.sql.parser.ASTUtil;
import zigen.sql.parser.ASTVisitorToString;
import zigen.sql.parser.INode;
import zigen.sql.parser.ISqlParser;
import zigen.sql.parser.Node;
import zigen.sql.parser.SqlParser;
import zigen.sql.parser.ast.ASTParentheses;
import zigen.sql.parser.exception.ParserException;

public class TestOffset extends TestCase {
	private void check(String in, int begin, int end) {
		try {
			ISqlParser parser = new SqlParser(in, new SqlFormatRule());
			INode node = new Node("root");
			parser.parse(node);

			ASTVisitorToString visitor = new ASTVisitorToString();
			node.accept(visitor, null);
			visitor.print();
			FileUtil.writeXml(getClass().getName(), parser.dumpXml(node));

			ASTParentheses p = (ASTParentheses) ASTUtil.findChildDepth(node, "ASTParentheses");

			assertEquals(begin, p.getOffset());
			assertEquals(end, p.getEndOffset());
		} catch (ParserException e) {
			e.printStackTrace();
			fail();
		}
	}

	public void test1() {
		StringBuffer in = new StringBuffer();
		in.append("()");
		check(in.toString(), 0, 1);
	}

	public void test2() {
		StringBuffer in = new StringBuffer();
		in.append("(     )");
		check(in.toString(), 0, 6);
	}

}
